package com.samplelogger;

import com.illumon.intradaylogger.IntradayLogger;
import com.illumon.iris.binarystore.Row;
/**
 * Created by paulchambre on 10/9/17.
 */
public interface TickDataLogFormat1Interface extends IntradayLogger {
    void log(Row.Flags flags,
         long timestamp,
         char exchange,
         String security,
         String underlying,
         int bidSize,
         float bidPrice,
         int askSize,
         float askPrice,
         char tradeStatus,
         char tickCondition,
         long exchangeTimestamp,
         long exchangeTimeNanos);

    default void log(long timestamp,
                     char exchange,
                     String security,
                     String underlying,
                     int bidSize,
                     float bidPrice,
                     int askSize,
                     float askPrice,
                     char tradeStatus,
                     char tickCondition,
                     long exchangeTimestamp,
                     long exchangeTimeNanos) {
        log(DEFAULT_INTRADAY_LOGGER_FLAGS, timestamp, exchange, security, underlying, bidSize, bidPrice, askSize, askPrice, tradeStatus, tickCondition, exchangeTimestamp, exchangeTimeNanos);
    }
}


