package com.samplelogger;

import com.fishlib.configuration.Configuration;
import com.fishlib.io.log.LogLevel;
import com.fishlib.io.logger.Logger;
import com.fishlib.logger.LogCreator;
import com.fishlib.logger.ProcessUnsafeLogCreator;
import com.illumon.intradaylogger.LongLivedProcessBinaryStoreWriterFactory;
import com.illumon.iris.db.tables.utils.DBDateTime;
import com.samplelogger.tickdata.gen.*;

import java.io.IOException;

/**
 * A sample logger application that will write two rows into a binary log file using the samplelogger.tickdata class.
 * The default logging path is /var/log/deephaven/misc. This can be overridden by setting the logroot property.
 */
public class TestLog {

    public static void main(String[] args) {
        org.apache.log4j.BasicConfigurator.configure();
        final Configuration configuration = Configuration.getInstance();
        final LogCreator processLogCreator = new ProcessUnsafeLogCreator("TestTickData", configuration);
        final Logger log = processLogCreator.createLogger("TestTickData", LogLevel.INFO);

        final TickDataLogFormat1Logger logger = new TickDataLogFormat1Logger();

        try {
            logger.init(new LongLivedProcessBinaryStoreWriterFactory(configuration.getLogPath("TickDataLog.bin"), log), 10000);
        } catch (IOException e) {
            throw new RuntimeException("Something went wrong initializing the quoteLogger.", e);
        }
        logger.log(
                DBDateTime.now().getMillis(),
                'N',
                "AAPL_12321",
                "AAPL",
                10,
                777.77F,
                10,
                888.88F,
                'N',
                'A',
                1000000000L,
                1000000000000000L);
        logger.log(
                DBDateTime.now().getMillis(),
                'A',
                "GOOG_12321",
                "GOOG",
                10,
                777.77F,
                10,
                888.88F,
                'F',
                'N',
                DBDateTime.now().getMillis(),
                DBDateTime.now().getMillis()*1000000);
        logger.shutdown();
    }
}
