# **************    Cookbook / Working with Time / Python   ************** 
# **************   Copyright 2019 Deephaven Data Labs, LLC  ************** 

# This notebook is part of the Deephaven Query Cookbook. For more information, 
# please refer to the Deephaven Documentation Portal at 
# https://docs.deephaven.io/latest/Content/quickReference/cookbook/cookbook.htm


# Filtering By Time

import illumon.iris.Calendars as cals
usnyse = cals.calendar("USNYSE")
trades = db.t("LearnIris", "StockTrades")\
    .where("Date=`2017-08-25`")\
    .view("Sym", "Last", "ExchangeTimestamp")
usnyseTime = trades.where("usnyse.isBusinessTime(ExchangeTimestamp)")
afternoon = usnyseTime.where("ExchangeTimestamp > '2017-08-25T12:00 NY'")



# DateTime Strings

import illumon.iris.DBTimeUtils as dbtu
trades = db.t("LearnIris", "StockTrades")\
    .where("Date=`2017-08-25`")\
    .view("Sym", "Last", "ExchangeTimestamp")
time = dbtu.convertDateTime("2017-08-25T12:00 NY")
afternoon = trades.where("ExchangeTimestamp > time")


# Adjusting Time Mathematically

trades = db.t("LearnIris", "StockTrades")\
    .where("Date=`2017-08-25`")\
    .view("Sym", "Last", "ExchangeTimestamp")
hourAfter1 = trades.updateView("HourAfter = ExchangeTimestamp + '01:00'")
hourAfter2 = trades.updateView("HourAfter = ExchangeTimestamp + 'T1h'")
hourAfter3 = trades.updateView("HourAfter = ExchangeTimestamp + HOUR")
timeDifference = trades.updateView("Difference=diffDay(ExchangeTimestamp, currentTime())")