# **************        Cookbook / Plotting / Python        ************** 
# **************   Copyright 2019 Deephaven Data Labs, LLC  ************** 

# This notebook is part of the Deephaven Query Cookbook. For more information, 
# please refer to the Deephaven Documentation Portal at
# https://docs.deephaven.io/latest/Content/quickReference/cookbook/cookbook.htm


# XY Series

import illumon.iris.plot as plot
trades = db.t("LearnIris", "StockTrades")\
   .where("Date=`2017-08-25`")\
   .view("Sym", "Last", "Size", "ExchangeTimestamp")

timePlot = plot.plot("Microsoft", trades.where("Sym=`MSFT`"), "ExchangeTimestamp", "Last")\
   .show()
						
multiSeries = plot.plot("Microsoft", trades.where("Sym=`MSFT`"), "ExchangeTimestamp", "Last")\
   .twinX()\
   .plot("Apple", trades.where("Sym=`AAPL`"), "ExchangeTimestamp", "Last")\
   .chartTitle("Price Over Time")\
   .show()

    
# Category

import illumon.iris.plot as plot
trades = db.t("LearnIris", "StockTrades")\
   .where("Date=`2017-08-25`")\
   .view("Sym", "Last", "Size", "ExchangeTimestamp")

totalShares = trades.view("Sym", "SharesTraded=Size").sumBy("Sym")

categoryPlot = plot.catPlot("Shares Traded", totalShares, "Sym", "SharesTraded")\
   .chartTitle("Total Shares")\
   .show()


# Pie

import illumon.iris.plot as plot
trades = db.t("LearnIris", "StockTrades")\
   .where("Date=`2017-08-25`")\
   .view("Sym", "Last", "Size", "ExchangeTimestamp")

pieChart = plot.piePlot("Shares Traded", totalShares, "Sym", "SharesTraded")\
   .chartTitle("Total Shares")\
   .show()

  
    
# Histogram

import illumon.iris.plot as plot
trades = db.t("LearnIris", "StockTrades")\
   .where("Date=`2017-08-25`")\
   .view("Sym", "Last", "Size", "ExchangeTimestamp")

histogram = plot.histPlot("MSFT", trades.where("Sym=`MSFT`"), "Last", 3)\
   .chartTitle("Price Intervals")\
   .show()

    

# Category Histogram

import illumon.iris.plot as plot
trades = db.t("LearnIris", "StockTrades")\
   .where("Date=`2017-08-25`")\
   .view("Sym", "Last", "Size", "ExchangeTimestamp")

catHist = plot.catHistPlot("Number of Trades", trades, "Sym")\
   .chartTitle("Trades per Symbol")\
   .show()

    
# Open, High, Low and Close

import illumon.iris.plot as plot

summaries = db.t("LearnIris", "EODTrades").where("ImportDate=`2017-11-01`")

ohlcPlot = plot.ohlcPlot("MSFT", summaries.where("Ticker=`MSFT`"), "EODTimestamp", "Open", "High", "Low","Close")\
   .chartTitle("Microsoft Activity")\
   .show()



# Grouping Multiple Plots in the Same Figure

import illumon.iris.plot as plot

trades = db.t("LearnIris", "StockTrades")\
   .where("Date=`2017-08-25`")\
   .view("Sym", "Last", "Size", "ExchangeTimestamp")

summaries = db.t("LearnIris", "EODTrades").where("ImportDate=`2017-11-01`")

multipleCharts = plot.figure(2,3)\
   .figureTitle("Trade Plots")\
\
.colSpan(3)\
.plot("Microsoft", trades.where("Sym=`MSFT`"), "ExchangeTimestamp", "Last")\
   .twinX()\
.plot("Apple", trades.where("Sym=`AAPL`"), "ExchangeTimestamp", "Last")\
   .chartTitle("Price Over Time")\
\
.newChart()\
.histPlot("MSFT", trades.where("Sym=`MSFT`"), "Last", 3)\
.chartTitle("Price Intervals")\
.newChart()\
   .colSpan(2)\
   .ohlcPlot("MSFT", summaries.where("Ticker=`MSFT`"), "EODTimestamp", "Open", "High", "Low","Close")\
   .chartTitle("Microsoft Activity")\
.show()